
(* 2x1 flyways w/ 2 xbots - waituntil cmdlb,waituntil displacement *)
FUNCTION_BLOCK Example04_waituntil
	(*async move to 60,60 and 60,180*)
	xbotID_array78[0] := 1;xbotID_array78[1] := 2;
	PosX_array78[0] := 0.06;PosX_array78[1] := 0.18;
	PosY_array78[0] := 0.06;PosY_array78[1] := 0.06;
	PMC_AutoDrivingMotion1(PM_Controller := PM_Controller,Execute := Execute,nXbots := 2,RoutingType := 0,ZoneID := 0,XbotID := xbotID_array78,PosX := PosX_array78,PosY := PosY_array78);

	(* xbot 2 linear move to 180,180*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := PMC_AutoDrivingMotion1.Done,cmdLB := 2,XbotID := 2,Mode := 0,Type_ := 0,PosX := 0.18,PosY := 0.18,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*xbot 1 wait until xbot 2 does command label 5*)
	PMC_WaitUntilCmdLb1(PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Done,cmdLB := 3,XbotID := 1,TriggerXID := 2,TriggerType := 0,TriggerCmdLb := 5,LabelType := 0);

	(* load command to move xbot 1 to 180,60*)
	PMC_XYMotion2(PM_Controller := PM_Controller,Execute := PMC_WaitUntilCmdLb1.Ack,cmdLB := 4,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.18,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(* delay for 1 second*)
	Delay1(Execute := PMC_XYMotion2.Ack,Cycles := 1000);

	(*xbot 2 move to 300,180 w/ cmd lb 5*)
	PMC_XYMotion3(PM_Controller := PM_Controller,Execute := Delay1.Done,cmdLB := 5,XbotID := 2,Mode := 0,Type_ := 0,PosX := 0.3,PosY := 0.18,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*xbot 1 waituntil xbot 2 is x > 299.9*)
	PMC_WaitUntilDisp1(PM_Controller := PM_Controller,Execute := PMC_XYMotion2.Done,cmdLB := 6,XbotID := 1,TriggerXID := 2,dispMode := 0,dispType := 0,Threshold := 0.2999,posXFactor := 0,posYFactor := 0);

	(* load command to move xbot 1 to 180,180*)
	PMC_XYMotion4(PM_Controller := PM_Controller,Execute := PMC_WaitUntilDisp1.Ack,cmdLB := 7,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.18,PosY := 0.18,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(* xbot 2 to 300,60*)
	PMC_XYMotion5(PM_Controller := PM_Controller,Execute := PMC_XYMotion4.Ack,cmdLB := 8,XbotID := 2,Mode := 0,Type_ := 0,PosX := 0.3,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(* xbot 1 waituntil xbot 2 is y < 60.1 mm*)
	PMC_WaitUntilDisp2(PM_Controller := PM_Controller,Execute := PMC_XYMotion4.Done,cmdLB := 9,XbotID := 1,TriggerXID := 2,dispMode := 1,dispType := 1,Threshold := 0.0601,posXFactor := 0,posYFactor := 0);

	(* load command to move xbot 1 to 420,180*)
	PMC_XYMotion6(PM_Controller := PM_Controller,Execute := PMC_WaitUntilDisp2.Ack,cmdLB := 10,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.42,PosY := 0.18,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(* move xbot 2 to 420,60*)
	PMC_XYMotion7(PM_Controller := PM_Controller,Execute := PMC_XYMotion6.Ack,cmdLB := 11,XbotID := 2,Mode := 0,Type_ := 0,PosX := 0.42,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	Done := PMC_XYMotion6.Done;
END_FUNCTION_BLOCK
